<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../helpers/format_uang.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// Ambil laba bersih
$laba = $db->query("
    SELECT 
        (SUM(k.total) + IFNULL(SUM(a.bunga),0) - IFNULL(SUM(b.jumlah),0)) AS laba
    FROM kasir_transaksi k
    LEFT JOIN pinjaman_angsuran a ON 1=1
    LEFT JOIN biaya_operasional b ON 1=1
")->fetch_assoc()['laba'];

// Persentase pembagian SHU
$shu_anggota = 0.60;   // 60%
$shu_cadangan = 0.25;  // 25%
$shu_pengurus = 0.15;  // 15%

// Hitung SHU
$shu_untuk_anggota = $laba * $shu_anggota;
$shu_cadangan_total = $laba * $shu_cadangan;
$shu_pengurus_total = $laba * $shu_pengurus;

// Total simpanan anggota
$total_simpanan = $db->query("
    SELECT SUM(jumlah) AS total FROM simpanan_transaksi
")->fetch_assoc()['total'];

// Data anggota
$anggota = $db->query("
    SELECT a.id, a.nama, SUM(s.jumlah) AS simpanan
    FROM anggota a
    LEFT JOIN simpanan_transaksi s ON a.id = s.anggota_id
    GROUP BY a.id
");
?>

<h2>Pembagian SHU</h2>

<h3>Ringkasan SHU</h3>
<table class="table">
    <tr><td>Laba Bersih</td><td><?= format_uang($laba); ?></td></tr>
    <tr><td>SHU Anggota (60%)</td><td><?= format_uang($shu_untuk_anggota); ?></td></tr>
    <tr><td>SHU Cadangan (25%)</td><td><?= format_uang($shu_cadangan_total); ?></td></tr>
    <tr><td>SHU Pengurus (15%)</td><td><?= format_uang($shu_pengurus_total); ?></td></tr>
</table>

<hr>

<h3>SHU Anggota</h3>
<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Nama Anggota</th>
            <th>Total Simpanan</th>
            <th>SHU Diterima</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $no=1;
        while($a = $anggota->fetch_assoc()):
            $persen = ($total_simpanan > 0) ? ($a['simpanan'] / $total_simpanan) : 0;
            $shu_diterima = $shu_untuk_anggota * $persen;
        ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= $a['nama']; ?></td>
            <td><?= format_uang($a['simpanan']); ?></td>
            <td><?= format_uang($shu_diterima); ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php require_once '../../templates/footer.php'; ?>
